#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
void DBG() { cerr << "]" << endl; }
template<class H, class... T> void DBG(H h, T... t) { cerr << to_string(h); if(sizeof...(t)) cerr << ", "; DBG(t...); }
#define dbg(...) cerr << "[" << #__VA_ARGS__ << "]: [", DBG(__VA_ARGS__)

const int mxN = 1e5 + 3;
const int logn = 19;
vector<int> adj[mxN];
int tin[mxN], tout[mxN], depth[mxN], timer = 0;
int up[mxN][logn];

void dfs(int u, int d, int p) {
    depth[u] = d;
    tin[u] = timer++;
    up[u][0] = p;
    for (int j = 1; j < logn; j++) {
        up[u][j] = up[up[u][j-1]][j-1];
    }
    for (auto x : adj[u]) if (x != p) {
        dfs(x, d+1, u);
    }
    tout[u] = timer;
}

bool IsAncestor(int u, int v) {
    return (tin[u] <= tin[v] && tout[u] >= tout[v]);
}

int get_lca(int u, int v) {
    if (IsAncestor(u, v)) return u;
    if (IsAncestor(v, u)) return v;
    for (int j = logn-1; j >= 0; j--) {
        if (up[u][j] != 0 && !IsAncestor(up[u][j], v))
            u = up[u][j];
    }
    return up[u][0];
}

void Putevi(int N, int M, int Q, int* U, int* V, int* W, int* X, int* Y, int* Ans) {
    for (int i = 1; i <= N; i++) {
        adj[U[i]].push_back(V[i]);
        adj[V[i]].push_back(U[i]);
    }
    dfs(1, 1, 0);

    for (int i = 1; i <= Q; i++) {
        int u = X[i], v = Y[i];
        int lca = get_lca(u, v);
        Ans[i] = depth[lca];
    }
}